--
-- OVAL-id: OVAL477
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0904' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Exchange Server 2003 (gold edition) is installed

	(SELECT 'Exchange Server 2003 (gold edition) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Exchange\Setup' AND
		EntryName = 'Services Version' AND
		EntryValue = '65')

AND EXISTS

	-- the version of exprox.dll is less than 6.5.6980.57

	(SELECT 'the version of exprox.dll is less than 6.5.6980.57' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\bin\exprox.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Exchange\Setup' AND
			EntryName = 'Services') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 6980 OR Version3 = 6980 AND
		Version4 < 57))))))

AND NOT EXISTS

	-- the patch KB832759 is installed

	(SELECT 'the patch KB832759 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Exchange Server 2003\SP1\832759')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- this is a front-end server providing Outlook Web Access

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND EXISTS

	-- the back-end server is Exchange Server 2003 running on Windows 2003

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND NOT EXISTS

	-- HTTP connection reuse is disabled

	(SELECT 'HTTP connection reuse is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\MSExchangeWEB\DAV' AND
		EntryName = 'ReuseConnections' AND
		EntryValue = '0')

AND EXISTS

	-- Kerberos is disabled on the virtual server that hosts OWA on the Exchange Server 2003 back-end server

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

--
-- ### END VULNERABLE CONFIGURATION
;

