--
-- OVAL-id: OVAL466
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0147' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- affected version of SSL and TLS components for OpenSSL
	(SELECT 'affected version of SSL and TLS components for OpenSSL' FROM Placeholder WHERE

	EXISTS
		-- openssl version is less than 0.9.7a-5

		(SELECT 'openssl version is less than 0.9.7a-5' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.7a' AND
			RPMTestedRelease = '5' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl-devel version is less than 0.9.7a-5

		(SELECT 'openssl-devel version is less than 0.9.7a-5' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.7a' AND
			RPMTestedRelease = '5' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl-perl version is less than 0.9.7a-5

		(SELECT 'openssl-perl version is less than 0.9.7a-5' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl-perl' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.7a' AND
			RPMTestedRelease = '5' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl096 version is less than 0.9.6-17

		(SELECT 'openssl096 version is less than 0.9.6-17' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl096' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.6' AND
			RPMTestedRelease = '17' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl096b version is less than 0.9.6b-6

		(SELECT 'openssl096b version is less than 0.9.6b-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl096b' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.6b' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

