--
-- OVAL-id: OVAL451
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0350' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of sp3res.dll is less than 5.0.2195.6713

	(SELECT 'the version of sp3res.dll is less than 5.0.2195.6713' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\sp3res.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6713))))))

AND EXISTS

	-- the version of umandlg.dll is less than 1.0.0.3

	(SELECT 'the version of umandlg.dll is less than 1.0.0.3' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\umandlg.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 1 OR (Version1 = 1 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 3))))))

AND NOT EXISTS

	-- Patch KB822679 Installed

	(SELECT 'Patch KB822679 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB822679' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

