--
-- OVAL-id: OVAL445
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0190' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssh-server version is less than 3.5p1-6.9

	(SELECT 'openssh-server version is less than 3.5p1-6.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssh-server' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.5p1' AND
		RPMTestedRelease = '6.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- sshd listens on the network

	(SELECT 'sshd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%sshd%')

--
-- ### END VULNERABLE CONFIGURATION
;

