--
-- OVAL-id: OVAL4345
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0214' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of shell32.dll is less than 5.0.3900.6970

	(SELECT 'the version of shell32.dll is less than 5.0.3900.6970' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3900 OR Version3 = 3900 AND
		Version4 < 6970))))))

AND NOT EXISTS

	-- the patch q841356 is installed (Hotfix key)

	(SELECT 'the patch q841356 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841356' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

