--
-- OVAL-id: OVAL4276
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0575' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- 64-Bit version of Windows is installed

	(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
		EntryName = 'PROCESSOR_ARCHITECTURE' AND
		EntryValue = 'ia64')

AND EXISTS

	-- the 64-bit WOW version of zipfldr.dll is less than 6.0.3790.198

	(SELECT 'the 64-bit WOW version of zipfldr.dll is less than 6.0.3790.198' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\SysWOW64\zipfldr.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 198))))))

AND NOT EXISTS

	-- the patch q873376 is installed (Hotfix key)

	(SELECT 'the patch q873376 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB873376' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- Compressed Folders with zipfldr.dll are enabled

	(SELECT 'Compressed Folders with zipfldr.dll are enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CompressedFolder' AND
		EntryName = 'FriendlyTypeName' AND
		EntryValue LIKE '%*zipfldr_dll*%')

--
-- ### END VULNERABLE CONFIGURATION
;

