--
-- OVAL-id: OVAL424
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0020' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of tlntsvr.exe is less than 5.0.33668.1

	(SELECT 'the version of tlntsvr.exe is less than 5.0.33668.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\tlntsvr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 33668 OR Version3 = 33668 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q307298 Installed

	(SELECT 'Patch Q307298 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q307298' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows 2000 Security Roll-up 1 Installed

	(SELECT 'Windows 2000 Security Roll-up 1 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\SP2SRP1' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the telnet service is enabled

	(SELECT 'the telnet service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tlntsvr' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

