--
-- OVAL-id: OVAL42
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0391' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- rpc.cmsd or dmispd exist
	(SELECT 'rpc.cmsd or dmispd exist' FROM Placeholder WHERE

	EXISTS
		-- File rpc.cmsd exists

		(SELECT 'File rpc.cmsd exists' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.cmsd')

	OR EXISTS
		-- File dmispd exists

		(SELECT 'File dmispd exists' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/dmi/dmispd'))

AND NOT EXISTS

	-- Patches 106942-22 and 108451-06
	(SELECT 'Patches 106942-22 and 108451-06' FROM Placeholder WHERE

	EXISTS
		-- Patch 106942-22 or later installed

		(SELECT 'Patch 106942-22 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '106942' AND
			PatchVersion >= '22')

	AND EXISTS
		-- Patch 108541-06 or later installed

		(SELECT 'Patch 108541-06 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '108541' AND
			PatchVersion >= '6'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.cmsd enabled OR dmispd running
	(SELECT 'rpc.cmsd enabled OR dmispd running' FROM Placeholder WHERE

	EXISTS
		-- rpc.cmsd enabled
		(SELECT 'rpc.cmsd enabled' FROM Placeholder WHERE

		EXISTS
			-- inetd.conf contains rpc.cmsd

			(SELECT 'inetd.conf contains rpc.cmsd' FROM Solaris_InetdConf WHERE
				ServerProgram = '/usr/dt/bin/rpc.cmsd')

		AND EXISTS
			-- inetd running

			(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
				Command LIKE '%inetd%' AND
				UserID = 'root')

		AND EXISTS
			-- File rpc.cmsd executable
			(SELECT 'File rpc.cmsd executable' FROM Placeholder WHERE

			EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					UEXEC = '1')

			OR EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					GEXEC = '1')

			OR EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					OEXEC = '1')))

	OR EXISTS
		-- dmispd running

		(SELECT 'dmispd running' FROM Solaris_PSInfo WHERE
			Command LIKE '%dmispd%'))

--
-- ### END VULNERABLE CONFIGURATION
;

