--
-- OVAL-id: OVAL4030
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0800' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 109613-07 or later installed

	(SELECT 'Patch 109613-07 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '109613' AND
		PatchVersion >= '07')

AND NOT EXISTS

	-- Patch 112810-06 or later installed

	(SELECT 'Patch 112810-06 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112810' AND
		PatchVersion >= '06')

AND EXISTS

	-- CDE Desktop Applications (SUNWdtdst) installed                                                                                               

	(SELECT 'CDE Desktop Applications (SUNWdtdst) installed                                                                                               ' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWdtdst')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

