--
-- OVAL-id: OVAL403
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0694' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of hhsetup.dll is less than 5.2.3644.0

	(SELECT 'the version of hhsetup.dll is less than 5.2.3644.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\hhsetup.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3644 OR Version3 = 3644 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of itircl.dll is less than 5.2.3644.0

	(SELECT 'the version of itircl.dll is less than 5.2.3644.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itircl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3644 OR Version3 = 3644 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of itss.dll is less than 5.2.3644.0

	(SELECT 'the version of itss.dll is less than 5.2.3644.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3644 OR Version3 = 3644 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- the patch q323255 is installed (Hotfix key)

	(SELECT 'the patch q323255 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q323255' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

