--
-- OVAL-id: OVAL367
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0822' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000, XP, or 2003 is installed
	(SELECT 'Windows 2000, XP, or 2003 is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	OR EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	OR EXISTS
		-- Windows Server 2003 is installed

		(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.2'))

AND EXISTS

	-- a vulnerable version of fp30reg.dll or fp5areg.dll exists
	(SELECT 'a vulnerable version of fp30reg.dll or fp5areg.dll exists' FROM Placeholder WHERE

	EXISTS
		-- the version of fp5areg.dll is less than 10.00.4205.0000

		(SELECT 'the version of fp5areg.dll is less than 10.00.4205.0000' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\50\bin\fp5areg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 10 OR (Version1 = 10 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 4205 OR Version3 = 4205 AND
			Version4 < 0000))))))

	OR EXISTS
		-- the version of fp30reg.dll is less than 10.00.4205.0000

		(SELECT 'the version of fp30reg.dll is less than 10.00.4205.0000' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\50\bin\fp30reg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 10 OR (Version1 = 10 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 4205 OR Version3 = 4205 AND
			Version4 < 0000)))))))

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2002 are enabled (NT, 2K, XP)

	(SELECT 'FrontPage Server Extensions 2002 are enabled (NT, 2K, XP)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\5.0\Setup Packages' AND
		EntryName = 'Microsoft FrontPage Server Extensions 2002')

--
-- ### END VULNERABLE CONFIGURATION
;

