--
-- OVAL-id: OVAL3604
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0420' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 with Active Desktop Installed
	(SELECT 'Windows NT 4.0 with Active Desktop Installed' FROM Placeholder WHERE

	EXISTS
		-- Active Desktop  is installed

		(SELECT 'Active Desktop  is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{89820200-ECBD-11cf-8B85-00AA005B4395}' AND
			EntryName = 'IsInstalled' AND
			EntryValue = '1')

	AND EXISTS
		-- Windows NT 4.0 is installed

		(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '4.0'))

AND EXISTS

	-- the version of shell32.dll is less than 4.72.3841.1100

	(SELECT 'the version of shell32.dll is less than 4.72.3841.1100' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 72 OR (Version2 = 72 AND
		(Version3 < 3841 OR Version3 = 3841 AND
		Version4 < 1100))))))

AND NOT EXISTS

	-- the patch kb839645 is installed

	(SELECT 'the patch kb839645 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839645' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

