--
-- OVAL-id: OVAL3483
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0661' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP is installed

	(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.1')

AND NOT EXISTS

	-- Patch WindowsXP-KB824105-x86-ENU.exe installed on XP or XP SP1
	(SELECT 'Patch WindowsXP-KB824105-x86-ENU.exe installed on XP or XP SP1' FROM Placeholder WHERE

	EXISTS
		--  Patch WindowsXP-KB824105-x86-ENU.exe installed

		(SELECT ' Patch WindowsXP-KB824105-x86-ENU.exe installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows XP\SP1\KB824105\Filelist' AND
			EntryName = 'installed' AND
			EntryValue = '1')

	OR EXISTS
		--  Patch WindowsXP-KB824105-x86-ENU.exe installed on XP SP1

		(SELECT ' Patch WindowsXP-KB824105-x86-ENU.exe installed on XP SP1' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows XP\SP2\KB824105\Filelist' AND
			EntryName = 'installed' AND
			EntryValue = '1'))

AND EXISTS

	-- XP SP1 or Pre SP1 with correct netbt.sys version
	(SELECT 'XP SP1 or Pre SP1 with correct netbt.sys version' FROM Placeholder WHERE

	EXISTS
		-- Pre Service Pack XP and netbt.sys is less than 5.1.2600.117
		(SELECT 'Pre Service Pack XP and netbt.sys is less than 5.1.2600.117' FROM Placeholder WHERE

		EXISTS
			-- the version of netbt.sys is less than 5.1.2600.117

			(SELECT 'the version of netbt.sys is less than 5.1.2600.117' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\drivers\netbt.sys' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 117))))))

		AND EXISTS
			-- Win2K/XP/2003 service pack 1 (or later) is installed

			(SELECT 'Win2K/XP/2003 service pack 1 (or later) is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue IN ('Service Pack 1', 'Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

	OR EXISTS
		-- XP SP1 and netbt.sys is less than 5.1.2600.1243
		(SELECT 'XP SP1 and netbt.sys is less than 5.1.2600.1243' FROM Placeholder WHERE

		EXISTS
			-- the version of netbt.sys is less than 5.1.2600.1243

			(SELECT 'the version of netbt.sys is less than 5.1.2600.1243' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\drivers\netbt.sys' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1243))))))

		AND EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

