--
-- OVAL-id: OVAL3391
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0345' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP is installed

	(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.1')

AND NOT EXISTS

	-- Patch Windows2000-KB817606-x86-ENU.exe Installed

	(SELECT 'Patch Windows2000-KB817606-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB817606' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- XP SP1 or pre SP1 with version check on Srv.sys
	(SELECT 'XP SP1 or pre SP1 with version check on Srv.sys' FROM Placeholder WHERE

	EXISTS
		-- XP Pre- SP1 with Srv.sys is less than 5.1.2600.112
		(SELECT 'XP Pre- SP1 with Srv.sys is less than 5.1.2600.112' FROM Placeholder WHERE

		EXISTS
			-- File %windir%system32DriversSRV.SYS is less than 5.1.2600.112

			(SELECT 'File %windir%system32DriversSRV.SYS is less than 5.1.2600.112' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\Drivers\SRV.SYS' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 112))))))

		AND EXISTS
			-- Win2K/XP/2003 service pack 1 (or later) is installed

			(SELECT 'Win2K/XP/2003 service pack 1 (or later) is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue IN ('Service Pack 1', 'Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

	OR EXISTS
		-- XP SP1 and srv.sys is less than 5.1.2600.1193
		(SELECT 'XP SP1 and srv.sys is less than 5.1.2600.1193' FROM Placeholder WHERE

		EXISTS
			-- File %windir%system32DriversSRV.SYS is less than 5.1.2600.1193

			(SELECT 'File %windir%system32DriversSRV.SYS is less than 5.1.2600.1193' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\Drivers\SRV.SYS' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1193))))))

		AND EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

