--
-- OVAL-id: OVAL3386
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0420' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- the version of shell32.dll is less than 5.0.3900.6922

	(SELECT 'the version of shell32.dll is less than 5.0.3900.6922' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3900 OR Version3 = 3900 AND
		Version4 < 6922))))))

AND NOT EXISTS

	-- the patch kb839645 is installed

	(SELECT 'the patch kb839645 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839645' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Win2K/XP/2003 service pack 2 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

