--
-- OVAL-id: OVAL3376
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0215' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Outlook Express 6 is installed

	(SELECT 'Outlook Express 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Outlook Express\Version Info' AND
		EntryName = 'Current' AND
		EntryValue = '6,0,2600,0000')

AND EXISTS

	-- the version of inetcomm.dll is less than 6.0.2742.200

	(SELECT 'the version of inetcomm.dll is less than 6.0.2742.200' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetcomm.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2742 OR Version3 = 2742 AND
		Version4 < 200))))))

AND NOT EXISTS

	-- the patch kb823353 is installed 

	(SELECT 'the patch kb823353 is installed ' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_CLASSES_ROOT\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\kb823353' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- all users have the preview pane disabled

	(SELECT 'all users have the preview pane disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey LIKE '%HKEY_USERS\S-[-0-9]+\Identities\{[-0-9A-Z]+}\Software\Microsoft\Outlook\ Express\5.0\Mail' AND
		EntryName = 'ShowHybridView' AND
		EntryValue = '0')

--
-- ### END VULNERABLE CONFIGURATION
;

