--
-- OVAL-id: OVAL33
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0158' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File Xsun exists

	(SELECT 'File Xsun exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/Xsun')

AND NOT EXISTS

	-- Patch 108376-38 or later installed

	(SELECT 'Patch 108376-38 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108376' AND
		PatchVersion >= '38')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File Xsun SGID and executable
	(SELECT 'File Xsun SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			SGID = '1')

	AND EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

