--
-- OVAL-id: OVAL3161
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0208' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP is installed

	(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.1')

AND NOT EXISTS

	-- the patch KB840987 is installed (Hotfix key)

	(SELECT 'the patch KB840987 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840987' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- the version of vdmdbg.dll is less than 5.1.2600.1560

	(SELECT 'the version of vdmdbg.dll is less than 5.1.2600.1560' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\vdmdbg.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 2600 OR Version3 = 2600 AND
		Version4 < 1560))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

