--
-- OVAL-id: OVAL3120
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0206' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (sp5 or earlier) is installed
	(SELECT 'Windows 2000 (sp5 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 5 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 5 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- the version of netdde.exe is less than 5.0.2195.6952

	(SELECT 'the version of netdde.exe is less than 5.0.2195.6952' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\netdde.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6952))))))

AND EXISTS

	-- the version of nddenb32.dll is less than 5.0.2195.6922

	(SELECT 'the version of nddenb32.dll is less than 5.0.2195.6922' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\netdde.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6922))))))

AND NOT EXISTS

	-- the patch KB841533 is installed

	(SELECT 'the patch KB841533 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841533' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

