--
-- OVAL-id: OVAL3071
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0572' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- a vulnerable version of grpconv.exe exists on NT
	(SELECT 'a vulnerable version of grpconv.exe exists on NT' FROM Placeholder WHERE

	EXISTS
		-- NT Server and grpconv.exe less than 4.0.1381.7286
		(SELECT 'NT Server and grpconv.exe less than 4.0.1381.7286' FROM Placeholder WHERE

		EXISTS
			-- Windows server product option
			(SELECT 'Windows server product option' FROM Placeholder WHERE

			EXISTS
				-- this is an NT Server (stand-alone)

				(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue LIKE '%ServerNT%')

			OR EXISTS
				-- this is an NT Server (domain controller)

				(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue LIKE '%LanmanNT%'))

		AND EXISTS
			-- the version of grpconv.exe (system32) is less than 4.0.1381.7286

			(SELECT 'the version of grpconv.exe (system32) is less than 4.0.1381.7286' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\grpconv.exe' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 7286)))))))

	OR EXISTS
		-- NT Terminal Server and grpconv.exe less than 4.0.1381.33577
		(SELECT 'NT Terminal Server and grpconv.exe less than 4.0.1381.33577' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of grpconv.exe (system32) is less than 4.0.1381.33577

			(SELECT 'the version of grpconv.exe (system32) is less than 4.0.1381.33577' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\grpconv.exe' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 33577))))))))

AND NOT EXISTS

	-- the patch q841356 is installed (Hotfix key)

	(SELECT 'the patch q841356 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841356' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

