--
-- OVAL-id: OVAL30
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0055' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\inetsrv\smtpsvc.dll version is less than 5.0.2195.4905

	(SELECT 'File %windir%\system32\inetsrv\smtpsvc.dll version is less than 5.0.2195.4905' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\smtpsvc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 4905))))))

AND NOT EXISTS

	-- Patch Q313450

	(SELECT 'Patch Q313450' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q313450' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SMTP Enabled

	(SELECT 'SMTP Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SMTPSVC' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

