--
-- OVAL-id: OVAL296
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0352' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\rpcrt4.dll version is less than 5.0.2195.6753

	(SELECT 'File %windir%\system32\rpcrt4.dll version is less than 5.0.2195.6753' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6753))))))

AND NOT EXISTS

	-- Patch Windows2000-KB823980-x86-ENU.exe Installed

	(SELECT 'Patch Windows2000-KB823980-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB823980' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- DCOM is enabled on systems with SP3 or later
	(SELECT 'DCOM is enabled on systems with SP3 or later' FROM Placeholder WHERE

	EXISTS
		-- Win2K/XP/2003 service pack 3 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

	AND EXISTS
		-- DCOM is enabled

		(SELECT 'DCOM is enabled' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ole' AND
			EntryName = 'EnableDCOM' AND
			EntryValue = 'Y'))

--
-- ### END VULNERABLE CONFIGURATION
;

