--
-- OVAL-id: OVAL287
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0719' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Media Player for Windows XP is installed

	(SELECT 'Windows Media Player for Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MediaPlayer\8.0\Registration' AND
		EntryName = 'UDBVersion' AND
		EntryValue = '8.0.0.4477')

AND EXISTS

	-- the version of msdxm.ocx is less than 6.4.9.1121

	(SELECT 'the version of msdxm.ocx is less than 6.4.9.1121' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msdxm.ocx' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 4 OR (Version2 = 4 AND
		(Version3 < 9 OR Version3 = 9 AND
		Version4 < 1121))))))

AND EXISTS

	-- the version of dxmasf.dll is less than 6.4.9.1121

	(SELECT 'the version of dxmasf.dll is less than 6.4.9.1121' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\dxmasf.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 4 OR (Version2 = 4 AND
		(Version3 < 9 OR Version3 = 9 AND
		Version4 < 1121))))))

AND NOT EXISTS

	-- Patch wm308567 Installed

	(SELECT 'Patch wm308567 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows Media Player\wm308567' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

