--
-- OVAL-id: OVAL2847
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0210' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

NOT EXISTS

	-- the patch kb841872 is installed

	(SELECT 'the patch kb841872 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841872' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- the version of psxss.exe is less than 5.0.2195.6929

	(SELECT 'the version of psxss.exe is less than 5.0.2195.6929' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\psxss.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6929))))))

AND EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- POSIX is enabled

	(SELECT 'POSIX is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Subsystem' AND
		EntryName = 'Posix')

--
-- ### END VULNERABLE CONFIGURATION
;

