--
-- OVAL-id: OVAL28
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0539' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable config
	(SELECT 'Vulnerable config' FROM Placeholder WHERE

	EXISTS
		-- ddskk version is less than 11.6.0-11.90

		(SELECT 'ddskk version is less than 11.6.0-11.90' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ddskk' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '11.6.0' AND
			RPMTestedRelease = '11.90' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ddskk-xemacs version is less than 11.6.0-11.90

		(SELECT 'ddskk-xemacs version is less than 11.6.0-11.90' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ddskk-xemacs' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '11.6.0' AND
			RPMTestedRelease = '11.90' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

