--
-- OVAL-id: OVAL277
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1256' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of srvsvc.dll is less than 5.0.2195.6110

	(SELECT 'the version of srvsvc.dll is less than 5.0.2195.6110' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\srvsvc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- Patch Q329170 Installed

	(SELECT 'Patch Q329170 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q329170' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SMB Signing enabled

	(SELECT 'SMB Signing enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\lanmanserver\parameters' AND
		EntryName = 'enablesecuritysignature' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

