--
-- OVAL-id: OVAL2705
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0202' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP or Windows Server 2003 is installed

	(SELECT 'Windows XP or Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue IN ('5.1','5.2'))

AND EXISTS

	-- 64-Bit version of Windows is installed

	(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
		EntryName = 'PROCESSOR_ARCHITECTURE' AND
		EntryValue = 'ia64')

AND EXISTS

	-- DirectX 8.1 without kb839643 installed
	(SELECT 'DirectX 8.1 without kb839643 installed' FROM Placeholder WHERE

	EXISTS
		-- the version of dplayx.dll is less than 5.2.3790.163 on 64-bit edition

		(SELECT 'the version of dplayx.dll is less than 5.2.3790.163 on 64-bit edition' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\SysWOW64\dplayx.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 2 OR (Version2 = 2 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 163))))))

	AND EXISTS
		-- DirectX 8.1x Installed

		(SELECT 'DirectX 8.1x Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DirectX' AND
			EntryName = 'Version' AND
			EntryValue LIKE '4.08.01%')

	AND NOT EXISTS
		-- the patch kb839643 is installed

		(SELECT 'the patch kb839643 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB839643' AND
			EntryName = 'Installed' AND
			EntryValue = '1'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

