--
-- OVAL-id: OVAL27
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0193' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Installed
	(SELECT 'Internet Explorer 5.01 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.3800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.6307')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2920.0000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3103.1000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3105.0106')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3314.2101')

	OR EXISTS
		-- Internet Explorer 5.01 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3315.1000'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3504.2500

	(SELECT 'the version of mshtml.dll is less than 5.0.3504.2500' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3504 OR Version3 = 3504 AND
		Version4 < 2500))))))

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows 2000 Service Pack 4 (or later) is installed
	(SELECT 'Windows 2000 Service Pack 4 (or later) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- SP4 or later Installed

		(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue >= 'Service Pack 4'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

