--
-- OVAL-id: OVAL2671
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0862' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (sp3 or earlier) is installed
	(SELECT 'Windows 2000 (sp3 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- the version of cryptdlg.dll is less then 5.0.1558.6072

	(SELECT 'the version of cryptdlg.dll is less then 5.0.1558.6072' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\cryptdlg.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1558 OR Version3 = 1558 AND
		Version4 < 6072))))))

AND NOT EXISTS

	-- the patch Q329115 is installed

	(SELECT 'the patch Q329115 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q329115' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

