--
-- OVAL-id: OVAL2657
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0215' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- Outlook Express 6 for Windows 2003 is installed

	(SELECT 'Outlook Express 6 for Windows 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Outlook Express\Version Info' AND
		EntryName = 'Current' AND
		EntryValue = '6,0,3790,0')

AND NOT EXISTS

	-- the patch kb823353 is installed 

	(SELECT 'the patch kb823353 is installed ' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_CLASSES_ROOT\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\kb823353' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- a vulnerable version of inetcomm.dll exisits
	(SELECT 'a vulnerable version of inetcomm.dll exisits' FROM Placeholder WHERE

	EXISTS
		-- machine has followed the GDR update path and inetcomm.dll is less than 6.0.3790.181

		(SELECT 'machine has followed the GDR update path and inetcomm.dll is less than 6.0.3790.181' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\inetcomm.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 6 OR (Version1 = 6 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 181))))))

	OR EXISTS
		-- machine has followed the QFE update path and inetcomm.dll is less than 6.0.3790.185

		(SELECT 'machine has followed the QFE update path and inetcomm.dll is less than 6.0.3790.185' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\inetcomm.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 6 OR (Version1 = 6 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 185)))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- all users have the preview pane disabled

	(SELECT 'all users have the preview pane disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey LIKE '%HKEY_USERS\S-[-0-9]+\Identities\{[-0-9A-Z]+}\Software\Microsoft\Outlook\ Express\5.0\Mail' AND
		EntryName = 'ShowHybridView' AND
		EntryValue = '0')

--
-- ### END VULNERABLE CONFIGURATION
;

