--
-- OVAL-id: OVAL26
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0720' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

AND EXISTS

	-- the version of netman.dll is less than 5.0.2195.5974

	(SELECT 'the version of netman.dll is less than 5.0.2195.5974' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\netman.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5974))))))

AND NOT EXISTS

	-- Patch Q326886 Installed

	(SELECT 'Patch Q326886 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q326886' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

