--
-- OVAL-id: OVAL253
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0879' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND NOT EXISTS

	-- Patch Q305601 Installed

	(SELECT 'Patch Q305601 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\Q305601' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

