--
-- OVAL-id: OVAL2495
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0213' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of Sp3res.dll is less than 5.0.2195.6928

	(SELECT 'the version of Sp3res.dll is less than 5.0.2195.6928' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Sp3res.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6928))))))

AND EXISTS

	-- the version of Umandlg.dll is less than 1.0.0.5

	(SELECT 'the version of Umandlg.dll is less than 1.0.0.5' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Umandlg.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 1 OR (Version1 = 1 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 5))))))

AND NOT EXISTS

	-- the patch kb842526 is installed

	(SELECT 'the patch kb842526 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB842526' AND
		EntryName = 'Installed' AND
		EntryValue = '')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

