--
-- OVAL-id: OVAL2413
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0202' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- DirectX 8.1 without kb839643 installed
	(SELECT 'DirectX 8.1 without kb839643 installed' FROM Placeholder WHERE

	EXISTS
		-- the version of dplayx.dll is less than 5.2.3790.163 on 64-bit edition

		(SELECT 'the version of dplayx.dll is less than 5.2.3790.163 on 64-bit edition' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\SysWOW64\dplayx.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 2 OR (Version2 = 2 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 163))))))

	AND EXISTS
		-- DirectX 8.1x Installed

		(SELECT 'DirectX 8.1x Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DirectX' AND
			EntryName = 'Version' AND
			EntryValue LIKE '4.08.01%')

	AND NOT EXISTS
		-- the patch kb839643 is installed

		(SELECT 'the patch kb839643 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB839643' AND
			EntryName = 'Installed' AND
			EntryValue = '1'))

AND EXISTS

	-- Windows XP 64-bit with SP1 (or earlier) installed
	(SELECT 'Windows XP 64-bit with SP1 (or earlier) installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP (sp1 or earlier) is installed
		(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

		EXISTS
			-- Windows XP is installed

			(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CurrentVersion' AND
				EntryValue = '5.1')

		AND NOT EXISTS
			-- Win2K/XP/2003 service pack 2 (or later) is installed

			(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

