--
-- OVAL-id: OVAL2394
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0206' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT Server 4.0 is installed
	(SELECT 'Windows NT Server 4.0 is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows NT 4.0 is installed

		(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '4.0')

	AND EXISTS
		-- Windows server product option
		(SELECT 'Windows server product option' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Server (stand-alone)

			(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%ServerNT%')

		OR EXISTS
			-- this is an NT Server (domain controller)

			(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%LanmanNT%')))

AND EXISTS

	-- the version of nddenb32.dll is less than 4.0.1381.7268

	(SELECT 'the version of nddenb32.dll is less than 4.0.1381.7268' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\nddenb32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7268))))))

AND EXISTS

	-- the version of netdde.exe is less than 4.0.1381.7280

	(SELECT 'the version of netdde.exe is less than 4.0.1381.7280' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\netdde.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7280))))))

AND NOT EXISTS

	-- the patch KB841533 is installed

	(SELECT 'the patch KB841533 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841533' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

