--
-- OVAL-id: OVAL231
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2000-1081' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- File odsole70.dll Version3 is less than 223

	(SELECT 'File odsole70.dll Version3 is less than 223' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'odsole70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 223 OR Version3 = 223 AND
		Version4 < 0))))))

AND EXISTS

	-- File xpqueue.dll Version3 is less than 223

	(SELECT 'File xpqueue.dll Version3 is less than 223' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpqueue.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 223 OR Version3 = 223 AND
		Version4 < 0))))))

AND EXISTS

	-- File xprepl.dll Version3 is less than 223

	(SELECT 'File xprepl.dll Version3 is less than 223' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xprepl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 223 OR Version3 = 223 AND
		Version4 < 0))))))

AND EXISTS

	-- File xpstar.dll Version3 is less than 223

	(SELECT 'File xpstar.dll Version3 is less than 223' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpstar.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 223 OR Version3 = 223 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- File sqlservr.exe version3 greater than or equal to 384

	(SELECT 'File sqlservr.exe version3 greater than or equal to 384' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 >= 2000 AND
	Version2 >= 80 AND
	Version3 >= 384 AND
	Version4 >= 0))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

