--
-- OVAL-id: OVAL2204
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0205' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND NOT EXISTS

	-- the patch q841373 is installed (Hotfix key)

	(SELECT 'the patch q841373 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q841373' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- the version of w3svc.dll is less than 4.2.788.1

	(SELECT 'the version of w3svc.dll is less than 4.2.788.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 788 OR Version3 = 788 AND
		Version4 < 1))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Permanent redirects enabled

	(SELECT 'Permanent redirects enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE '%LM\W3SVC\/d*\ROOT%' AND
		Id = '6011' AND
		Name = 'HttpRedirect' AND
		Data LIKE 'http:*,PERMANENT,*%')

AND NOT EXISTS

	-- MaxClientRequestBufferData less than or equal to 16384

	(SELECT 'MaxClientRequestBufferData less than or equal to 16384' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\w3svc\parameters' AND
		EntryName = 'MaxClientRequestBufferData' AND
		EntryValue <= '16384')

--
-- ### END VULNERABLE CONFIGURATION
;

