--
-- OVAL-id: OVAL217
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0711' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of itircl.dll is less than 5.2.3790.80

	(SELECT 'the version of itircl.dll is less than 5.2.3790.80' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itircl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 80))))))

AND NOT EXISTS

	-- Patch KB825119 Installed

	(SELECT 'Patch KB825119 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB825119' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- HCP Protocol

	(SELECT 'HCP Protocol' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_CLASSES_ROOT\HCP')

--
-- ### END VULNERABLE CONFIGURATION
;

