--
-- OVAL-id: OVAL204
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0838' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 or IE 6.0 SP1 is installed
	(SELECT 'Internet Explorer 6.0 or IE 6.0 SP1 is installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 6 is installed

		(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '6.00.2600.0000')

	OR EXISTS
		-- Internet Explorer 6 Service Pack 1 is installed

		(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '6.00.2800.1106'))

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2800.1264

	(SELECT 'the version of mshtml.dll is less than 6.0.2800.1264' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1264))))))

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls are enabled
	(SELECT 'ActiveX controls are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls are enabled
		(SELECT 'current user settings are being used and ActiveX controls are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls are enabled
		(SELECT 'local machine settings are being used and ActiveX controls are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')))

AND EXISTS

	-- .hta applications are enabled

	(SELECT '.hta applications are enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MIME\Database\Content Type\application/hta' AND
		EntryName = 'Extension' AND
		EntryValue = '.hta')

--
-- ### END VULNERABLE CONFIGURATION
;

