--
-- OVAL-id: OVAL201
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0659' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of user32.dll exists
	(SELECT 'a vulnerable version of user32.dll exists' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and user32.dll is less than 5.1.2600.118
		(SELECT 'no service pack is installed and user32.dll is less than 5.1.2600.118' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of user32.dll is less than 5.1.2600.118

			(SELECT 'the version of user32.dll is less than 5.1.2600.118' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\user32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 118)))))))

	OR EXISTS
		-- service pack 1 is installed and user32.dll is less than 5.1.2600.1255
		(SELECT 'service pack 1 is installed and user32.dll is less than 5.1.2600.1255' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of user32.dll is less than 5.1.2600.1255

			(SELECT 'the version of user32.dll is less than 5.1.2600.1255' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\user32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1255))))))))

AND NOT EXISTS

	-- the patch kb824141 is installed (Hotfix key)

	(SELECT 'the patch kb824141 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB824141' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the utility manager Service is enabled

	(SELECT 'the utility manager Service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\UtilMan' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

