--
-- OVAL-id: OVAL1997
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0119' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Version checks on XP for Ipnathlp.dll
	(SELECT 'Version checks on XP for Ipnathlp.dll' FROM Placeholder WHERE

	EXISTS
		-- No service pack is installed and the version of Ipnathlp.dll is less than 5.1.2600.137
		(SELECT 'No service pack is installed and the version of Ipnathlp.dll is less than 5.1.2600.137' FROM Placeholder WHERE

		EXISTS
			-- The version of Ipnathlp.dll is less than 5.1.2600.137

			(SELECT 'The version of Ipnathlp.dll is less than 5.1.2600.137' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\System32\Ipnathlp.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 137))))))

		AND EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion'))

	OR EXISTS
		-- The version of Ipnathlp.dll is less than 5.1.2600.1364 and windows service pack 1 is installed
		(SELECT 'The version of Ipnathlp.dll is less than 5.1.2600.1364 and windows service pack 1 is installed' FROM Placeholder WHERE

		EXISTS
			-- The version of Ipnathlp.dll is less than 5.1.2600.1364

			(SELECT 'The version of Ipnathlp.dll is less than 5.1.2600.1364' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\System32\Ipnathlp.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1364))))))

		AND EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1'))

	OR EXISTS
		-- 64 bit version of windows with service pack 1 installed and the version of Ipnathlp.dll is less than 5.1.2600.1364
		(SELECT '64 bit version of windows with service pack 1 installed and the version of Ipnathlp.dll is less than 5.1.2600.1364' FROM Placeholder WHERE

		EXISTS
			-- The version of Ipnathlp.dll is less than 5.1.2600.1364 and windows service pack 1 is installed
			(SELECT 'The version of Ipnathlp.dll is less than 5.1.2600.1364 and windows service pack 1 is installed' FROM Placeholder WHERE

			EXISTS
				-- The version of Ipnathlp.dll is less than 5.1.2600.1364

				(SELECT 'The version of Ipnathlp.dll is less than 5.1.2600.1364' FROM Windows_FileAttributes WHERE
					FilePath = (SELECT EntryValue || '\System32\Ipnathlp.dll' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'SystemRoot') AND
					(Version1 < 5 OR (Version1 = 5 AND
					(Version2 < 1 OR (Version2 = 1 AND
					(Version3 < 2600 OR Version3 = 2600 AND
					Version4 < 1364))))))

			AND EXISTS
				-- Win2K/XP/2003 service pack 1 is installed

				(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'CSDVersion' AND
					EntryValue = 'Service Pack 1'))

		AND EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')))

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Negotiate is enabled

	(SELECT 'Negotiate is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6032' AND
		Data LIKE '%Negotiate%')

--
-- ### END VULNERABLE CONFIGURATION
;

