--
-- OVAL-id: OVAL199
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0863' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Terminal Server Version

	(SELECT 'Terminal Server Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Terminal Server' AND
		EntryName = 'ProductVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\drivers\rdpwd.sys version is less than 5.0.2195.5880

	(SELECT 'File %windir%\system32\drivers\rdpwd.sys version is less than 5.0.2195.5880' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\drivers\rdpwd.sys' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5880))))))

AND NOT EXISTS

	-- Patch Q324380 installed

	(SELECT 'Patch Q324380 installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q324380' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- RDP Enabled

	(SELECT 'RDP Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\RDPWD' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

