--
-- OVAL-id: OVAL198
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0660' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\cryptui.dll version is less than 5.131.2195.6758

	(SELECT 'File %windir%\system32\cryptui.dll version is less than 5.131.2195.6758' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\cryptui.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 131 OR (Version2 = 131 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6758))))))

AND NOT EXISTS

	-- Patch WindowsXP-KB823182-x86-ENU Installed

	(SELECT 'Patch WindowsXP-KB823182-x86-ENU Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB823182' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- downloading of signed ActiveX controls is enabled
	(SELECT 'downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and the downloading of signed ActiveX controls is enabled
		(SELECT 'current user settings are being used and the downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- downloading of signed ActiveX controls is enabled for the local machine

			(SELECT 'downloading of signed ActiveX controls is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1001' AND
				EntryValue != '3'))

	AND EXISTS
		-- local machine settings are being used and the downloading of signed ActiveX controls is enabled
		(SELECT 'local machine settings are being used and the downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- downloading of signed ActiveX controls is enabled for the current user

			(SELECT 'downloading of signed ActiveX controls is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1001' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

