--
-- OVAL-id: OVAL1852
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0206' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT Server 4.0, Terminal Server Edition is installed
	(SELECT 'Windows NT Server 4.0, Terminal Server Edition is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows NT 4.0 is installed

		(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '4.0')

	AND EXISTS
		-- this is an NT Terminal Server

		(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
			EntryName = 'ProductSuite' AND
			EntryValue = 'Terminal Server'))

AND EXISTS

	-- the version of nddenb32.dll is less than 4.0.1381.33565

	(SELECT 'the version of nddenb32.dll is less than 4.0.1381.33565' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\nddenb32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 33565))))))

AND EXISTS

	-- the version of netdde.exe is less than 4.0.1381.33574

	(SELECT 'the version of netdde.exe is less than 4.0.1381.33574' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\netdde.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 33574))))))

AND NOT EXISTS

	-- the patch KB841533 is installed

	(SELECT 'the patch KB841533 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841533' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

