--
-- OVAL-id: OVAL1751
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0208' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

NOT EXISTS

	-- the patch KB840987 is installed (Hotfix key)

	(SELECT 'the patch KB840987 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840987' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- the version of win32k.sys is less than 5.2.3790.198

	(SELECT 'the version of win32k.sys is less than 5.2.3790.198' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\win32k.sys' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 198))))))

AND EXISTS

	-- Windows 2003 Server or Windows XP 64-bit
	(SELECT 'Windows 2003 Server or Windows XP 64-bit' FROM Placeholder WHERE

	EXISTS
		-- Windows XP 64-bit
		(SELECT 'Windows XP 64-bit' FROM Placeholder WHERE

		EXISTS
			-- Windows XP is installed

			(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CurrentVersion' AND
				EntryValue = '5.1')

		AND EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64'))

	OR EXISTS
		-- Windows Server 2003 is installed

		(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.2'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

