--
-- OVAL-id: OVAL175
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0678' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 110286-09 or later installed

	(SELECT 'Patch 110286-09 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110286' AND
		PatchVersion >= '9')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

