--
-- OVAL-id: OVAL1530
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0201' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- the version of itss.dll is less than 5.2.3790.185

	(SELECT 'the version of itss.dll is less than 5.2.3790.185' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 185))))))

AND NOT EXISTS

	-- the patch kb840315 is installed

	(SELECT 'the patch kb840315 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840315' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- HTML Help is registered

	(SELECT 'HTML Help is registered' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Classes\ITSProtocol')

--
-- ### END VULNERABLE CONFIGURATION
;

