--
-- OVAL-id: OVAL152
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1317' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File fs.auto exists

	(SELECT 'File fs.auto exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/lib/fs.auto')

AND EXISTS

	-- File xfs exists

	(SELECT 'File xfs exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xfs')

AND NOT EXISTS

	-- Patch 108117-06 or later installed

	(SELECT 'Patch 108117-06 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108117' AND
		PatchVersion >= '6')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains fs.auto

	(SELECT 'inetd.conf contains fs.auto' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/openwin/lib/fs.auto')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File xfs executable
	(SELECT 'File xfs executable' FROM Placeholder WHERE

	EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			UEXEC = '1')

	OR EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			GEXEC = '1')

	OR EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

