--
-- OVAL-id: OVAL148
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0541' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gtkhtml version is less than 1.1.9-0.9.1

	(SELECT 'gtkhtml version is less than 1.1.9-0.9.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gtkhtml' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.1.9' AND
		RPMTestedRelease = '0.9.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/evolution is executable
	(SELECT '/usr/bin/evolution is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/evolution is executable

		(SELECT '/usr/bin/evolution is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/evolution' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/evolution is executable

		(SELECT '/usr/bin/evolution is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/evolution' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/evolution is executable

		(SELECT '/usr/bin/evolution is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/evolution' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

