--
-- OVAL-id: OVAL1427
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0718' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP is installed

	(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.1')

AND EXISTS

	-- a vulnerable version of httpext.dll exists
	(SELECT 'a vulnerable version of httpext.dll exists' FROM Placeholder WHERE

	EXISTS
		-- Service pack 1 and the version of httpext.dll is less than 6.0.2600.1579
		(SELECT 'Service pack 1 and the version of httpext.dll is less than 6.0.2600.1579' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of httpext.dll is less than 6.0.2600.1579

			(SELECT 'the version of httpext.dll is less than 6.0.2600.1579' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\inetsrv\httpext.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 6 OR (Version1 = 6 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1579)))))))

	OR EXISTS
		-- no service pack and the version of httpext.dll is less than 6.0.2600.165
		(SELECT 'no service pack and the version of httpext.dll is less than 6.0.2600.165' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of httpext.dll is less than 6.0.2600.165

			(SELECT 'the version of httpext.dll is less than 6.0.2600.165' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\inetsrv\httpext.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 6 OR (Version1 = 6 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 165))))))))

AND NOT EXISTS

	-- the patch KB824151 is installed

	(SELECT 'the patch KB824151 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB824151' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

